function [stks] = imnormvol()
%This takes image stacks and does a 3d normalization via imnorm and saves
%out the files.
%Synatax:   [stks] = imnormvol(); 
%Input:     none right now
%Output:    stks = the normalized image stacks

%get the image stacks
[stks,img_range,filenames,pathname] = stack_gui(1);  %use cell output mode.

%make sure filename is a cell array
if ~iscell(filenames)
    filenames = {filenames};
end

%normalize image stacks
for j = 1:size(stks,2)
    stks{1,j} = imnorm(stks{1,j});
end

%make the output directory
mkdir(pathname,'normalized');
%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end
%Now save out the image files
for i = 1:size(filenames,2)
    mkdir([pathname,'normalized'],filenames{1,i}(1:end-4));
    stk2tiff(stks{1,i},filenames{1,i},[pathname,'normalized',slash,filenames{1,i}(1:end-4),slash]);
end